const MAX_STRING_LONG_NETNAME_IN_TABLE = 48;
const MAX_STRING_SHORT_NETNAME_IN_TABLE = 25;
const MAX_STRING_LENGTH_IN_TABLE = 18;
const MAX_STRING_USERID_LENGTH_IN_TABLE = 15;
const MAX_STRING_USER_SHORT_LENGTH_IN_TABLE = 19;
const MAX_STRING_USER_MEDIUM_LENGTH_IN_TABLE = 23;
const MAX_STRING_USER_LONG_LENGTH_IN_TABLE = 32;
const MAX_STRING_USER_LONG_LENGTH_IN_TILE = 21;
const MAX_STRING_USER_NAME_IN_TABLE = 10;
const MAX_STRING_LENGTH_IN_TABLE_ON_DASHBOARD = 24;
const MAX_STRING_LENGTH_FOR_EMAIL = 14;
const MAX_STRING_LENGTH_FOR_PHONE = 17;
const MAX_STRING_LENGTH_FULL_COUNTRY = 23;
const MAX_STRING_LENGTH_FOR_TILE = 15;
const MAX_STRING_DEVICE_OS_LENGTH = 10;
const MAX_STRING_LENGTH_URL = 32;
const MAX_STRING_LENGTH_ENDPOINT = 21;
const MAX_TOOLTIP_URL_LENGTH = 50;
const MAX_TOOLTIP_LENGTH = 121;

const COLOR_RED    = '#FB6E88';
const COLOR_GREEN  = '#01EE99';
const COLOR_YELLOW = '#F5B944';
const COLOR_PURPLE = '#BE95EB';

const COLOR_LIGHT_GREEN = 'rgba(64,220,97,0.03)';
const COLOR_LIGHT_YELLOW = 'rgba(225,224,137,0.03)';
const COLOR_LIGHT_RED = 'rgba(255,51,102,0.03)';
const COLOR_LIGHT_PURPLE = 'rgba(190,149,235,0.03)';

const USER_LOW_TRUST_SCORE_INF    = 0;
const USER_LOW_TRUST_SCORE_SUP    = 33;
const USER_MEDIUM_TRUST_SCORE_INF = 33;
const USER_MEDIUM_TRUST_SCORE_SUP = 67;
const USER_HIGH_TRUST_SCORE_INF   = 67;

const USER_IPS_CRITICAL_VALUE       = 9;
const USER_EVENTS_CRITICAL_VALUE    = Infinity;
const USER_DEVICES_CRITICAL_VALUE   = 4;
const USER_COUNTRIES_CRITICAL_VALUE = 3;

const MAX_HOURS_CHART = 96;
const MIN_HOURS_CHART = 3;
const DAYS_IN_RANGE = 1;
const X_AXIS_SERIFS = 8;

const ASN_OVERRIDE = {
    '0':        'LAN',
    '64496':    'N/A',
};

const COUNTRIES_EXCEPTIONS = [null, undefined, 'N/A', 'AN', 'CS', 'YU'];

const NORMAL_DEVICES = ['smartphone', 'desktop', 'bot', 'tablet'];

const PHONE_LANDLINE = [
    'landline',
    'FIXED_LINE',
    'FIXED_LINE_OR_MOBILE',
    'TOLL_FREE',
    'SHARED_COST',
];

const NO_RULES_MSG = {
    value:      'No rule',
    tooltip:    'User currently doesn\'t correspond to selected rules.',
};

const UNDEFINED_RULES_MSG = {
    value:      'In queue',
    tooltip:    'Waiting for a score to be calculated.',
};

const MIDLINE_HELLIP = '\u22EF';
const HELLIP = '\u2026';
const HYPHEN = '\uFF0D';

const COLOR_MAP = {
    'red':      {
        'main':     COLOR_RED,
        'light':    COLOR_LIGHT_RED,
    },
    'yellow':   {
        'main':     COLOR_YELLOW,
        'light':    COLOR_LIGHT_YELLOW,
    },
    'green':    {
        'main':     COLOR_GREEN,
        'light':    COLOR_LIGHT_GREEN,
    },
    'purple':   {
        'main':     COLOR_PURPLE,
        'light':    COLOR_LIGHT_PURPLE,
    },
};

export {
    MAX_STRING_LONG_NETNAME_IN_TABLE,
    MAX_STRING_SHORT_NETNAME_IN_TABLE,
    MAX_STRING_LENGTH_IN_TABLE,
    MAX_STRING_USERID_LENGTH_IN_TABLE,
    MAX_STRING_USER_SHORT_LENGTH_IN_TABLE,
    MAX_STRING_USER_MEDIUM_LENGTH_IN_TABLE,
    MAX_STRING_USER_LONG_LENGTH_IN_TABLE,
    MAX_STRING_USER_LONG_LENGTH_IN_TILE,
    MAX_STRING_USER_NAME_IN_TABLE,
    MAX_STRING_LENGTH_IN_TABLE_ON_DASHBOARD,
    MAX_STRING_LENGTH_FOR_EMAIL,
    MAX_STRING_LENGTH_FOR_PHONE,
    MAX_STRING_LENGTH_FULL_COUNTRY,
    MAX_STRING_LENGTH_FOR_TILE,
    MAX_STRING_DEVICE_OS_LENGTH,
    MAX_STRING_LENGTH_URL,
    MAX_STRING_LENGTH_ENDPOINT,
    MAX_TOOLTIP_URL_LENGTH,
    MAX_TOOLTIP_LENGTH,

    COLOR_RED,
    COLOR_GREEN,
    COLOR_YELLOW,
    COLOR_PURPLE,

    COLOR_LIGHT_GREEN,
    COLOR_LIGHT_YELLOW,
    COLOR_LIGHT_RED,
    COLOR_LIGHT_PURPLE,

    USER_LOW_TRUST_SCORE_INF,
    USER_LOW_TRUST_SCORE_SUP,
    USER_MEDIUM_TRUST_SCORE_INF,
    USER_MEDIUM_TRUST_SCORE_SUP,
    USER_HIGH_TRUST_SCORE_INF,

    USER_IPS_CRITICAL_VALUE,
    USER_EVENTS_CRITICAL_VALUE,
    USER_DEVICES_CRITICAL_VALUE,
    USER_COUNTRIES_CRITICAL_VALUE,

    MAX_HOURS_CHART,
    MIN_HOURS_CHART,
    DAYS_IN_RANGE,
    X_AXIS_SERIFS,

    ASN_OVERRIDE,

    COUNTRIES_EXCEPTIONS,
    NORMAL_DEVICES,
    PHONE_LANDLINE,
    NO_RULES_MSG,
    UNDEFINED_RULES_MSG,

    MIDLINE_HELLIP,
    HELLIP,
    HYPHEN,

    COLOR_MAP,
};
