<?php

/**
 * tirreno ~ open security analytics
 * Copyright (c) Tirreno Technologies Sàrl (https://www.tirreno.com)
 *
 * Licensed under GNU Affero General Public License version 3 of the or any later version.
 * For full copyright and license information, please see the LICENSE
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright (c) Tirreno Technologies Sàrl (https://www.tirreno.com)
 * @license       https://opensource.org/licenses/AGPL-3.0 AGPL License
 * @link          https://www.tirreno.com Tirreno(tm)
 */

declare(strict_types=1);

namespace Models\Grid\FieldAuditTrail;

class Grid extends \Models\Grid\Base\Grid {
    public function __construct(int $apiKey) {
        parent::__construct();

        $this->apiKey = $apiKey;
        $this->idsModel = new Ids($apiKey);
        $this->query = new Query($apiKey);
    }

    public function getDataByUserId(int $userId): array {
        $params = [':account_id' => $userId];

        return $this->getGrid($this->idsModel->getDataIdsByUserId(), $params);
    }

    public function getDataByFieldId(int $fieldId): array {
        $params = [':field_id' => $fieldId];

        return $this->getGrid($this->idsModel->getDataIdsByFieldId(), $params);
    }

    public function getDataByResourceId(int $resourceId): array {
        $params = [':resource_id' => $resourceId];

        return $this->getGrid($this->idsModel->getDataIdsByResourceId(), $params);
    }

    public function getAllData(): array {
        return $this->getGrid();
    }

    protected function convertTimeToUserTimezone(array &$result): void {
        $fields = ['created'];

        \Utils\TimeZones::translateTimeZones($result, $fields);
    }
}
