# Contributions welcome!


### Here's a quick guide:

 1. [Fork the repo on GitHub](https://github.com/bobthecow/Ruler).

 2. Run the test suite. We only take pull requests with passing tests, and it's great to know that you have a clean slate. Make sure you have PHPUnit 3.5+, then run `phpunit` from the project directory.

 3. Add tests for your change. Only refactoring and documentation changes require no new tests. If you are adding functionality or fixing a bug, add a test!

 4. Make the tests pass.

 5. Push your fork to GitHub and submit a pull request.


### You can do some things to increase the chance that your pull request is accepted the first time:

 * Submit one pull request per fix or feature.
 * To help with that, do all your work in a feature branch (e.g. `feature/my-alsome-feature`).
 * Follow the conventions you see used in the project.
 * Use `phpcs --standard=PSR2` to check your changes against the coding standard.
 * Write tests that fail without your code, and pass with it.
 * Update any documentation: docblocks, README, examples, etc.


### Ruler follows the PSR-* coding standards:

 * [PSR-0: Class and file naming conventions](https://github.com/php-fig/fig-standards/blob/master/accepted/PSR-0.md)
 * [PSR-1: Basic coding standard](https://github.com/php-fig/fig-standards/blob/master/accepted/PSR-1-basic-coding-standard.md)
 * [PSR-2: Coding style guide](https://github.com/php-fig/fig-standards/blob/master/accepted/PSR-2-coding-style-guide.md)
