<?php

/**
 * tirreno ~ open-source security framework
 * Copyright (c) Tirreno Technologies Sàrl (https://www.tirreno.com)
 *
 * Licensed under GNU Affero General Public License version 3 of the or any later version.
 * For full copyright and license information, please see the LICENSE
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright (c) Tirreno Technologies Sàrl (https://www.tirreno.com)
 * @license       https://opensource.org/licenses/AGPL-3.0 AGPL License
 * @link          https://www.tirreno.com Tirreno(tm)
 */

declare(strict_types=1);

namespace Tirreno\Utils\Assets\Lists;

class Url extends Base {
    protected static string $extensionFile = 'url.php';

    protected static array $list = [
        '%00',
        '%20AND%20',
        '%20OR%20',
        '%20and%20',
        '%20or%20',
        '%252e%252e%252f',
        '%252e%252e%255c',
        '%2e%2e%2f',
        '%2e%2e%5c',
        '%2e%2e/',
        '%2e%2e\\',
        '%c0%ae%c0%ae%c0%af',
        '%uff0e%uff0e%u2215',
        '%uff0e%uff0e%u2216',
        '&exec',
        '\' OR \'1\'=\'1',
        '\'=\'',
        '*/',
        '..%255c',
        '..%2f',
        '..%5c',
        '..%c0%af',
        '..%c1%9c',
        '../',
        '..\\',
        '..\/',
        './',
        '.\\',
        '.env',
        '.env.example',
        '.exe',
        '.git',
        '.htaccess',
        '.htpasswd',
        '.sh',
        '.well-known/',
        '/*',
        '/Dix8',
        '/FdOc',
        '/Wp-includes',
        '/app/index.js',
        '/bY3o',
        '/bc',
        '/bk',
        '/conf',
        '/database',
        '/etc',
        '/graphql',
        '/new',
        '/old',
        '/pki-validation',
        '/proc',
        '/sandbox',
        '/secrets',
        '/solr',
        '/var',
        '/var/www',
        '/wp-admin',
        '/wp-content',
        '/wp-head',
        '/wp-header',
        '/wp-includes',
        '/wp-info',
        '/wp-login',
        '/wso',
        '1=1',
        ';',
        '<script>',
        '?page=',
        'C:',
        'CAT%20',
        'CdRom0',
        'GLOBALROOT',
        'Inetpub',
        'SELECT%20',
        'alert(',
        'apache',
        'autoload',
        'backdoor',
        'backup',
        'bash_history',
        'c:',
        'cat%20',
        'cgi-bin',
        'cjfuns',
        'cmd=',
        'cmdshell',
        'composer',
        'composer.php',
        'core-plugin',
        'curl',
        'diskVolume',
        'document.cookie',
        'eval(',
        'eval-stdin.php',
        'ftp',
        'gaocc',
        'get.asp',
        'get.cgi',
        'get.php',
        'httpd',
        'id_rsa',
        'include.php',
        'indexes',
        'inetpub',
        'install.php',
        'javascript:',
        'localhost',
        'modext',
        'netcat',
        'nginx',
        'onerror=',
        'onload=',
        'passwd',
        'password.txt',
        'passwords.txt',
        'phpmyadmin',
        'plugins',
        'select%20',
        'sftp.json',
        'sh_history',
        'shadow',
        'ssh',
        'system32',
        'uname',
        'url:file',
        'url:http',
        'vsftpd',
        'web.config',
        'wget',
        'win.ini',
        'wp',
        'wp-config',
        'wwwroot',
    ];
}
