<?php

/**
 * tirreno ~ open-source security framework
 * Copyright (c) Tirreno Technologies Sàrl (https://www.tirreno.com)
 *
 * Licensed under GNU Affero General Public License version 3 of the or any later version.
 * For full copyright and license information, please see the LICENSE
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright (c) Tirreno Technologies Sàrl (https://www.tirreno.com)
 * @license       https://opensource.org/licenses/AGPL-3.0 AGPL License
 * @link          https://www.tirreno.com Tirreno(tm)
 */

declare(strict_types=1);

namespace Tirreno\Models\Chart;

class Country extends BaseEventsCount {
    public function getCounts(int $apiKey): array {
        $query = (
            "SELECT
                EXTRACT(EPOCH FROM date_trunc(:resolution, event.time + :offset))::bigint AS ts,
                COUNT(CASE WHEN event.type IN ({$this->normalFlatIds})  THEN TRUE END) AS event_normal_type_count,
                COUNT(CASE WHEN event.type IN ({$this->editFlatIds})    THEN TRUE END) AS event_editing_type_count,
                COUNT(CASE WHEN event.type IN ({$this->alertFlatIds})   THEN TRUE END) AS event_alert_type_count

            FROM
                event

            INNER JOIN event_ip
            ON (event.ip = event_ip.id)

            INNER JOIN countries
            ON (event_ip.country = countries.id)

            WHERE
                countries.id = :id AND
                event.key = :api_key AND
                event.time >= :start_time AND
                event.time <= :end_time

            GROUP BY ts
            ORDER BY ts"
        );

        return $this->executeOnRangeById($query, $apiKey);
    }
}
